	function [L, C, Rs, RL, K] = T_LADDER_2_PI(L, C, Rs, RL, K)
	
	% 	Converts an equaly terminated lowpass T ladder with 
	% 	finite zeros into a  ladder.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 		Lars Wanhammar 2007-09-03
	%					
	%	Modified by: 	LW 2008-12-13, 2009-03-17 
	% 	Copyright:		by authors - not released for commercial use
	%	Version: 		1
	%	Known bugs: 
	%	Report bugs to:	Wanhammar@gmail.com	
	
	% Convert a T ladder into a  ladder
	Temp = L; L = C; C = Temp;
	for j = 1:length(K)
		if K(j) == 9
			K(j) = 2; 
		elseif K(j) == 2
			K(j) = 9;
		elseif K(j) == 10
			K(j) = 5;
		end
	end
	RL = Rs^2/RL;
